/*
 * Decompiled with CFR 0.152.
 */
package com.exoftware.exactor.command.abbot.converter;

import com.exoftware.exactor.Constants;
import com.exoftware.exactor.command.abbot.Util;
import com.exoftware.exactor.command.abbot.converter.AbbotToExactorConverter;
import com.exoftware.util.FileCollector;
import java.io.File;
import junit.framework.TestCase;
import org.jdom.Element;

public class AbbotToExactorConverterTest
extends TestCase {
    public void testAcceptance() throws Exception {
        File dir = new File(Constants.DATA_DIR + "/abbot");
        File[] abbotFiles = FileCollector.filesWithExtension((File)dir, (String)"xml");
        for (int i = 0; i < abbotFiles.length; ++i) {
            File abbotFile = abbotFiles[i];
            File expectedExactorFile = new File(dir, abbotFile.getName().replace(".xml", ".act"));
            String expected = Util.getFileContent((String)expectedExactorFile.getAbsolutePath());
            AbbotToExactorConverterTest.assertEquals((String)("Conversion of : " + abbotFile.getName() + " did not match content in " + expectedExactorFile.getName()), (String)expected.trim(), (String)AbbotToExactorConverter.convertToExactor((File)abbotFile, (boolean)true).trim());
        }
    }

    public void testConvertAbbotComponentXMLToExactorScript() throws Exception {
        this.assertComponentXMLToExactorScript("AbbotComponent \"CLASS\" \"ID\" \"NAME\" \"INDEX\" \"PARENT\" \"WINDOW\" \"ROOT\" \"TITLE\" \"TAG\" \"ICON\" \"INVOKER\" \"BORDERTITLE\"", "   <component class=\"CLASS\" \n              id=\"ID\"\n              index=\"INDEX\"\n              name=\"NAME\"\n              parent=\"PARENT\"\n              window=\"WINDOW\"\n              root=\"ROOT\"\n              title=\"TITLE\"\n              tag=\"TAG\"\n              icon=\"ICON\"\n              invoker=\"INVOKER\"\n              borderTitle=\"BORDERTITLE\"/>");
    }

    public void testConvertAbbotEventXMLToExactorScript() throws Exception {
        this.assertComponentXMLToExactorScript("AbbotEvent \"COMPONENT\" \"KIND\" \"TYPE\" \"X\" \"Y\" \"KEYCODE\" \"MODIFIERS\"", "    <event component=\"COMPONENT\"            kind=\"KIND\"            type=\"TYPE\"            x=\"X\"            y=\"Y\"            keyCode=\"KEYCODE\"            modifiers=\"MODIFIERS\"  />");
    }

    public void testConvertAbbotLaunchXMLToExactorScript() throws Exception {
        AbbotToExactorConverterTest.assertEquals((String)"AbbotLaunch \"com.exoftware.exactor.ide.ExactorIDE\" \"main\" \"[]\" \".\"", (String)AbbotToExactorConverter.processElement((Element)Util.createElement((String)"<launch args=\"[]\" class=\"com.exoftware.exactor.ide.ExactorIDE\" classpath=\".\" method=\"main\" />"), (boolean)false));
    }

    public void testConvertAbbotLaunchXMLToExactorScript_ChangeBackSlashesToForward() throws Exception {
        AbbotToExactorConverterTest.assertEquals((String)"AbbotLaunch \"com.exoftware.exactor.ide.ExactorIDE\" \"main\" \"[]\" \"c:/adir/ajar.jar\"", (String)AbbotToExactorConverter.processElement((Element)Util.createElement((String)"<launch args=\"[]\" class=\"com.exoftware.exactor.ide.ExactorIDE\" classpath=\"c:\\adir\\ajar.jar\" method=\"main\" />"), (boolean)false));
    }

    public void testConvertAbbotActionXMLToExactorScript() throws Exception {
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JTabbedPane\" \"actionSelectTab\" \"Tabbed Pane,\\\"tab 1\\\"\"", "<action args=\"Tabbed Pane,&quot;tab 1&quot;\" class=\"javax.swing.JTabbedPane\" method=\"actionSelectTab\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"java.awt.Dialog\" \"actionClose\" \"Dialog\"", "<action class=\"java.awt.Dialog\" method=\"actionClose\" args=\"Dialog\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"java.awt.TextComponent\" \"actionFocus\" \"textField\"", "<action class=\"java.awt.TextComponent\" method=\"actionFocus\" args=\"textField\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.AbstractButton\" \"actionClick\" \"OK\"", "<action class=\"javax.swing.AbstractButton\" method=\"actionClick\" args=\"OK\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.AbstractButton\" \"actionClick\" \"Select Test Suite...\"", "<action class=\"javax.swing.AbstractButton\" method=\"actionClick\" args=\"Select Test Suite...\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JButton\" \"actionClick\" \"Button\"", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Button\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JButton\" \"actionClick\" \"OK Button\"", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"OK Button\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JButton\" \"actionClick\" \"OK\"", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"OK\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JButton\" \"actionClick\" \"OK\"", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"OK\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JButton\" \"actionClick\" \"OK\"", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"OK\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JButton\" \"actionClick\" \"OK\"", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"OK\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JButton\" \"actionClick\" \"Run\"", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Run\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JButton\" \"actionClick\" \"Run\"", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Run\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JButton\" \"actionClick\" \"Select Test Suite...\"", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Select Test Suite...\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JButton\" \"actionClick\" \"Select Test Suite...\"", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Select Test Suite...\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JButton\" \"actionClick\" \"Select Test Suite...\"", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Select Test Suite...\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JButton\" \"actionClick\" \"Select Test Suite...\"", "<action class=\"javax.swing.JButton\" method=\"actionClick\" args=\"Select Test Suite...\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JComboBox\" \"actionSelectItem\" \"JComboBox Instance,Combo 10\"", "<action class=\"javax.swing.JComboBox\" method=\"actionSelectItem\" args=\"JComboBox Instance,Combo 10\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JComboBox\" \"actionSelectItem\" \"JComboBox Instance,Combo 10\"", "<action class=\"javax.swing.JComboBox\" method=\"actionSelectItem\" args=\"JComboBox Instance,Combo 10\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionShowPopupMenu\" \"Dynamic\"", "<action class=\"javax.swing.JLabel\" method=\"actionShowPopupMenu\" args=\"Dynamic\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionShowPopupMenu\" \"Dynamic\"", "<action class=\"javax.swing.JLabel\" method=\"actionShowPopupMenu\" args=\"Dynamic\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionShowPopupMenu\" \"Dynamic\"", "<action class=\"javax.swing.JLabel\" method=\"actionShowPopupMenu\" args=\"Dynamic\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionShowPopupMenu\" \"Dynamic\"", "<action class=\"javax.swing.JLabel\" method=\"actionShowPopupMenu\" args=\"Dynamic\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,-1,-1,Blue\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,-1,-1,Blue\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,-1,-1,Blue\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,-1,-1,Blue\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,32,4,Green\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,32,4,Green\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,32,4,Green\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,32,4,Green\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,32,4,Green\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,32,4,Green\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,Blue\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,Blue\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Dynamic,Blue\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Dynamic,Blue\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Static,-1,-1,Black\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Static,-1,-1,Black\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Static,-1,-1,White\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Static,-1,-1,White\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Static,Black\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Static,Black\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Static,Black\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Static,Black\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Static,White\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Static,White\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JLabel\" \"actionSelectPopupMenuItem\" \"Static,White\"", "<action class=\"javax.swing.JLabel\" method=\"actionSelectPopupMenuItem\" args=\"Static,White\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JList\" \"actionSelectValue\" \"JList Instance,MyCodeTest - example\"", "<action class=\"javax.swing.JList\" method=\"actionSelectValue\" args=\"JList Instance,MyCodeTest - example\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JList\" \"actionSelectValue\" \"JList Instance,MyCodeTest - example\"", "<action class=\"javax.swing.JList\" method=\"actionSelectValue\" args=\"JList Instance,MyCodeTest - example\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JList\" \"actionSelectValue\" \"JList Instance,MyCodeTest - example\"", "<action class=\"javax.swing.JList\" method=\"actionSelectValue\" args=\"JList Instance,MyCodeTest - example\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JList\" \"actionSelectIndex\" \"My List,0\"", "<action class=\"javax.swing.JList\" method=\"actionSelectIndex\" args=\"My List,0\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JList\" \"actionSelectIndex\" \"My List,7\"", "<action class=\"javax.swing.JList\" method=\"actionSelectIndex\" args=\"My List,7\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Copy\"", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Copy\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Copy\"", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Copy\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Copy\"", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Copy\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Copy\"", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Copy\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Item 1\"", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Item 1\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Item 1\"", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Item 1\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Item 1\"", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Item 1\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Item 1\"", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Item 1\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Submenu item\"", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Submenu item\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Submenu item\"", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Submenu item\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Submenu item\"", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Submenu item\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JMenuItem\" \"actionSelectMenuItem\" \"Submenu item\"", "<action class=\"javax.swing.JMenuItem\" method=\"actionSelectMenuItem\" args=\"Submenu item\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JTable\" \"actionSelectCell\" \"ScriptTable Instance,8,0\"", "<action class=\"javax.swing.JTable\" method=\"actionSelectCell\" args=\"ScriptTable Instance,8,0\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JTextField\" \"actionClick\" \"My Text Field,3,7\"", "<action class=\"javax.swing.JTextField\" method=\"actionClick\" args=\"My Text Field,3,7\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JTextField\" \"actionClick\" \"My Text Field,3,7\"", "<action class=\"javax.swing.JTextField\" method=\"actionClick\" args=\"My Text Field,3,7\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JTextField\" \"actionText\" \"My Text Field,Get outta here\"", "<action class=\"javax.swing.JTextField\" method=\"actionText\" args=\"My Text Field,Get outta here\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"javax.swing.JTextField\" \"actionText\" \"My Text Field,Get outta here\"", "<action class=\"javax.swing.JTextField\" method=\"actionText\" args=\"My Text Field,Get outta here\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"\" \"actionClick\" \"?\"", "<action method=\"actionClick\" args=\"?\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"\" \"actionClick\" \"High Button\"", "<action method=\"actionClick\" args=\"High Button\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"\" \"actionClick\" \"Low Button\"", "<action method=\"actionClick\" args=\"Low Button\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"\" \"actionSelectMenuItem\" \"New Script...\"", "<action method=\"actionSelectMenuItem\" args=\"New Script...\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"\" \"actionSelectMenuItem\" \"Run To\"", "<action method=\"actionSelectMenuItem\" args=\"Run To\" />");
        this.assertActionXMLToExactorScript("AbbotAction \"\" \"actionKeyStroke\" \"VK_ESCAPE\"", "<action method=\"actionKeyStroke\" args=\"VK_ESCAPE\" />");
    }

    private void assertActionXMLToExactorScript(String expectedExactorScript, String actionXML) throws Exception {
        AbbotToExactorConverterTest.assertEquals((String)expectedExactorScript, (String)AbbotToExactorConverter.processElement((Element)Util.createElement((String)actionXML), (boolean)false));
    }

    private void assertComponentXMLToExactorScript(String expectedExactorScript, String compXML) throws Exception {
        AbbotToExactorConverterTest.assertEquals((String)expectedExactorScript, (String)AbbotToExactorConverter.processElement((Element)Util.createElement((String)compXML), (boolean)false));
    }
}

