package europe.bikes.api;

import java.util.List;

import europe.bikes.api.model.Contract;
import europe.bikes.api.model.Station;
import io.reactivex.Observable;
import retrofit2.http.GET;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface EuropeanBikesApi {

    /**
     * Get the contract list.
     */
    @GET("contracts")
    Observable<List<Contract>> getContracts();

    /**
     * Get the station list.
     */
    @GET("stations")
    Observable<List<Station>> getStations();

    /**
     * Get the stations of a contract.
     *
     * @param contractName The name of the contract to list the stations of.
     */
    @GET("stations")
    Observable<List<Station>> getStationsOfContract(@Query("contract") String contractName);

    /**
     * Get station information.
     *
     * @param stationNumber The {@link Station#number()} of the desired station.
     * @param contractName  The {@link Contract#name()} of the desired station.
     */
    @GET("stations/{station_number}")
    Observable<Station> getStation(@Path("station_number") int stationNumber,
                                   @Query("contract") String contractName);

}
