/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.oauth;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import enterprises.orbital.oauth.AuthUtil;
import enterprises.orbital.oauth.EVEApi;
import enterprises.orbital.oauth.UserAccount;
import enterprises.orbital.oauth.UserAuthSource;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class EVECallbackHandler {
    private static final Logger log = Logger.getLogger(EVECallbackHandler.class.getName());

    public static String doGet(String clientID, String secretKey, String verifyURL, String callback, HttpServletRequest req) throws IOException {
        OAuth20Service service = (OAuth20Service)new ServiceBuilder().apiKey(clientID).apiSecret(secretKey).build((BaseApi)EVEApi.instance());
        try {
            OAuth2AccessToken accessToken = service.getAccessToken(req.getParameter("code"));
            OAuthRequest request = new OAuthRequest(Verb.GET, verifyURL, service.getConfig());
            service.signRequest(accessToken, (AbstractRequest)request);
            Response response = request.send();
            if (!response.isSuccessful()) {
                throw new IOException("credential request was not successful!");
            }
            UserAccount existing = AuthUtil.getCurrentUser(req);
            String charName = (String)new Gson().fromJson(new JsonParser().parse(response.getBody()).getAsJsonObject().get("CharacterName"), String.class);
            UserAuthSource sourceVal = AuthUtil.getBySourceScreenname("eve", charName);
            if (sourceVal != null) {
                if (existing != null) {
                    sourceVal.updateAccount(existing);
                    if (req.getSession().getAttribute("oe_addauth_redirect") != null) {
                        callback = (String)req.getSession().getAttribute("oe_addauth_redirect");
                        req.getSession().removeAttribute("oe_addauth_redirect");
                    }
                } else {
                    AuthUtil.signOn(req, sourceVal.getOwner(), sourceVal);
                }
            } else {
                UserAccount newUser = existing == null ? AuthUtil.createNewUserAccount(false) : existing;
                sourceVal = AuthUtil.createSource(newUser, "eve", charName, response.getBody());
                if (existing != null) {
                    if (req.getSession().getAttribute("oe_addauth_redirect") != null) {
                        callback = (String)req.getSession().getAttribute("oe_addauth_redirect");
                        req.getSession().removeAttribute("oe_addauth_redirect");
                    }
                } else {
                    AuthUtil.signOn(req, newUser, sourceVal);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed EVE authentication with error: ", e);
            callback = null;
        }
        return callback;
    }
}

