/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.oauth;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import enterprises.orbital.base.OrbitalProperties;
import enterprises.orbital.oauth.EVEOAuthServiceImpl;

public class EVEApi
extends DefaultApi20 {
    private static final String PROP_AUTH_URL = "enterprises.orbital.oauth.authURL";
    private static final String PROP_ACCESS_TOKEN_URL = "enterprises.orbital.oauth.accessURL";
    private static final String DEFAULT_AUTH_URL = "https://login.eveonline.com/oauth/authorize/";
    private static final String DEFAULT_ACCESS_TOKEN_URL = "https://login.eveonline.com/oauth/token";

    public static EVEApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public String getAccessTokenEndpoint() {
        return OrbitalProperties.getGlobalProperty((String)PROP_ACCESS_TOKEN_URL, (String)DEFAULT_ACCESS_TOKEN_URL);
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public OAuth20Service createService(OAuthConfig config) {
        return new EVEOAuthServiceImpl(this, config);
    }

    protected String getAuthorizationBaseUrl() {
        return OrbitalProperties.getGlobalProperty((String)PROP_AUTH_URL, (String)DEFAULT_AUTH_URL);
    }

    private static class InstanceHolder {
        private static final EVEApi INSTANCE = new EVEApi();

        private InstanceHolder() {
        }
    }
}

