/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.oauth;

import com.github.scribejava.apis.TwitterApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import enterprises.orbital.oauth.AuthUtil;
import enterprises.orbital.oauth.UserAccount;
import enterprises.orbital.oauth.UserAuthSource;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class TwitterCallbackHandler {
    private static final Logger log = Logger.getLogger(TwitterCallbackHandler.class.getName());

    public static String doGet(String twitterApiKey, String twitterApiSecret, String standardRedirect, HttpServletRequest req) throws IOException {
        OAuth10aService service = (OAuth10aService)new ServiceBuilder().apiKey(twitterApiKey).apiSecret(twitterApiSecret).build((BaseApi)TwitterApi.instance());
        OAuth1RequestToken requestToken = null;
        String caller = standardRedirect;
        try {
            requestToken = (OAuth1RequestToken)req.getSession().getAttribute("twitter_req_token");
            OAuth1AccessToken accessToken = service.getAccessToken(requestToken, req.getParameter("oauth_verifier"));
            OAuthRequest request = new OAuthRequest(Verb.GET, "https://api.twitter.com/1.1/account/verify_credentials.json", service.getConfig());
            service.signRequest(accessToken, (AbstractRequest)request);
            Response response = request.send();
            if (!response.isSuccessful()) {
                throw new IOException("credential request was not successful!");
            }
            UserAccount existing = AuthUtil.getCurrentUser(req);
            String screenName = (String)new Gson().fromJson(new JsonParser().parse(response.getBody()).getAsJsonObject().get("screen_name"), String.class);
            UserAuthSource sourceVal = AuthUtil.getBySourceScreenname("twitter", screenName);
            if (sourceVal != null) {
                if (existing != null) {
                    sourceVal.updateAccount(existing);
                    if (req.getSession().getAttribute("oe_addauth_redirect") != null) {
                        caller = (String)req.getSession().getAttribute("oe_addauth_redirect");
                        req.getSession().removeAttribute("oe_addauth_redirect");
                    }
                } else {
                    AuthUtil.signOn(req, sourceVal.getOwner(), sourceVal);
                }
            } else {
                UserAccount newUser = existing == null ? AuthUtil.createNewUserAccount(false) : existing;
                sourceVal = AuthUtil.createSource(newUser, "twitter", screenName, response.getBody());
                if (existing != null) {
                    if (req.getSession().getAttribute("oe_addauth_redirect") != null) {
                        caller = (String)req.getSession().getAttribute("oe_addauth_redirect");
                        req.getSession().removeAttribute("oe_addauth_redirect");
                    }
                } else {
                    AuthUtil.signOn(req, newUser, sourceVal);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed twitter authentication with error: ", e);
            caller = null;
        }
        return caller;
    }
}

