/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.oauth;

import com.github.scribejava.apis.TwitterApi;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.oauth.OAuth10aService;
import enterprises.orbital.oauth.AuthUtil;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class TwitterAuthHandler {
    private static final Logger log = Logger.getLogger(TwitterAuthHandler.class.getName());

    public static String doGet(String twitterApiKey, String twitterApiSecret, String callback, HttpServletRequest req) throws IOException {
        AuthUtil.prepAuthFlow(req);
        try {
            OAuth10aService service = (OAuth10aService)new ServiceBuilder().apiKey(twitterApiKey).apiSecret(twitterApiSecret).callback(callback).build((BaseApi)TwitterApi.instance());
            OAuth1RequestToken requestToken = service.getRequestToken();
            req.getSession().setAttribute("twitter_req_token", (Object)requestToken);
            return service.getAuthorizationUrl(requestToken);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error attempting twitter authentication", e);
            return null;
        }
    }
}

