/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.oauth;

import com.github.scribejava.apis.GoogleApi20;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import enterprises.orbital.oauth.AuthUtil;
import enterprises.orbital.oauth.UserAccount;
import enterprises.orbital.oauth.UserAuthSource;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class GoogleCallbackHandler {
    private static final Logger log = Logger.getLogger(GoogleCallbackHandler.class.getName());

    public static String doGet(String googleApiKey, String googleApiSecret, String googleScope, String redirectCallback, String standardRedirect, HttpServletRequest req) throws IOException {
        OAuth20Service service = (OAuth20Service)new ServiceBuilder().apiKey(googleApiKey).scope(googleScope).apiSecret(googleApiSecret).callback(redirectCallback).build((BaseApi)GoogleApi20.instance());
        String caller = standardRedirect;
        try {
            OAuth2AccessToken accessToken = service.getAccessToken(req.getParameter("code"));
            OAuthRequest request = new OAuthRequest(Verb.GET, "https://www.googleapis.com/oauth2/v2/userinfo?alt=json", service.getConfig());
            service.signRequest(accessToken, (AbstractRequest)request);
            Response response = request.send();
            if (!response.isSuccessful()) {
                throw new IOException("credential request was not successful!");
            }
            UserAccount existing = AuthUtil.getCurrentUser(req);
            String screenName = (String)new Gson().fromJson(new JsonParser().parse(response.getBody()).getAsJsonObject().get("email"), String.class);
            UserAuthSource sourceVal = AuthUtil.getBySourceScreenname("google", screenName);
            if (sourceVal != null) {
                if (existing != null) {
                    sourceVal.updateAccount(existing);
                    if (req.getSession().getAttribute("oe_addauth_redirect") != null) {
                        caller = (String)req.getSession().getAttribute("oe_addauth_redirect");
                        req.getSession().removeAttribute("oe_addauth_redirect");
                    }
                } else {
                    AuthUtil.signOn(req, sourceVal.getOwner(), sourceVal);
                }
            } else {
                UserAccount newUser = existing == null ? AuthUtil.createNewUserAccount(false) : existing;
                sourceVal = AuthUtil.createSource(newUser, "google", screenName, response.getBody());
                if (existing != null) {
                    if (req.getSession().getAttribute("oe_addauth_redirect") != null) {
                        caller = (String)req.getSession().getAttribute("oe_addauth_redirect");
                        req.getSession().removeAttribute("oe_addauth_redirect");
                    }
                } else {
                    AuthUtil.signOn(req, newUser, sourceVal);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed google authentication with error: ", e);
            caller = null;
        }
        return caller;
    }
}

