/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.oauth;

import enterprises.orbital.oauth.DisabledUserException;
import enterprises.orbital.oauth.UserAccount;
import enterprises.orbital.oauth.UserAccountProvider;
import enterprises.orbital.oauth.UserActionListener;
import enterprises.orbital.oauth.UserAuthSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class AuthUtil {
    public static final String UID_SESSION_VAR = "oe_true_user";
    public static final String SOURCE_SESSION_VAR = "oe_auth_source";
    public static final String ADDAUTH_REDIRECT_SESSION_VAR = "oe_addauth_redirect";
    private static final Logger log = Logger.getLogger(AuthUtil.class.getName());
    private static UserAccountProvider uaProvider = new UserAccountProvider(){

        @Override
        public UserAccount getAccount(String uid) {
            throw new IllegalStateException();
        }

        @Override
        public UserAuthSource getSource(UserAccount acct, String source) {
            throw new IllegalStateException();
        }

        @Override
        public void removeSourceIfExists(UserAccount acct, String source) {
            throw new IllegalStateException();
        }

        @Override
        public UserAuthSource getBySourceScreenname(String source, String screenName) {
            throw new IllegalStateException();
        }

        @Override
        public UserAuthSource createSource(UserAccount newUser, String source, String screenName, String body) {
            throw new IllegalStateException();
        }

        @Override
        public UserAccount createNewUserAccount(boolean b) {
            throw new IllegalStateException();
        }
    };
    private static List<UserActionListener> listeners = new ArrayList<UserActionListener>();

    public static void setUserAccountProvider(UserAccountProvider provider) {
        uaProvider = provider;
    }

    public static void prepAuthFlow(HttpServletRequest req) {
        if (AuthUtil.getCurrentUser(req) == null) {
            return;
        }
        if (req.getParameter("redirect") != null) {
            req.getSession().setAttribute(ADDAUTH_REDIRECT_SESSION_VAR, (Object)req.getParameter("redirect"));
        } else {
            req.getSession().removeAttribute(ADDAUTH_REDIRECT_SESSION_VAR);
        }
    }

    public static UserAccount getCurrentUser(HttpServletRequest req) {
        String uid = (String)req.getSession().getAttribute(UID_SESSION_VAR);
        String source = (String)req.getSession().getAttribute(SOURCE_SESSION_VAR);
        if (uid != null && source != null) {
            return uaProvider.getAccount(uid);
        }
        return null;
    }

    public static UserAuthSource getCurrentSource(HttpServletRequest req) {
        UserAccount acct = AuthUtil.getCurrentUser(req);
        if (acct == null) {
            return null;
        }
        String source = (String)req.getSession().getAttribute(SOURCE_SESSION_VAR);
        if (source == null) {
            return null;
        }
        return uaProvider.getSource(acct, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signOn(HttpServletRequest req, UserAccount user, UserAuthSource source) throws IOException {
        if (user.isDisabled()) {
            AuthUtil.signOff(req);
            throw new DisabledUserException();
        }
        req.getSession().setAttribute(UID_SESSION_VAR, (Object)user.getUid());
        req.getSession().setAttribute(SOURCE_SESSION_VAR, (Object)source.getSource());
        user.touch();
        source.touch();
        List<UserActionListener> list = listeners;
        synchronized (list) {
            for (UserActionListener next : listeners) {
                try {
                    next.loggedIn(user, source);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "Caught error in UserActionListener " + next + ", ignoring and continuing with other actions", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signOff(HttpServletRequest req) {
        UserAccount acct = AuthUtil.getCurrentUser(req);
        req.getSession().removeAttribute(UID_SESSION_VAR);
        req.getSession().removeAttribute(SOURCE_SESSION_VAR);
        List<UserActionListener> list = listeners;
        synchronized (list) {
            for (UserActionListener next : listeners) {
                try {
                    next.loggedOut(acct);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "Caught error in UserActionListener " + next + ", ignoring and continuing with other actions", e);
                }
            }
        }
    }

    public static void removeSourceIfExists(UserAccount acct, String source) {
        uaProvider.removeSourceIfExists(acct, source);
    }

    public static UserAuthSource getBySourceScreenname(String source, String screenName) {
        return uaProvider.getBySourceScreenname(source, screenName);
    }

    public static UserAuthSource createSource(UserAccount newUser, String source, String screenName, String body) {
        return uaProvider.createSource(newUser, source, screenName, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserAccount createNewUserAccount(boolean b) {
        UserAccount newUser = uaProvider.createNewUserAccount(b);
        List<UserActionListener> list = listeners;
        synchronized (list) {
            for (UserActionListener next : listeners) {
                try {
                    next.userCreated(newUser);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "Caught error in UserActionListener " + next + ", ignoring and continuing with other actions", e);
                }
            }
        }
        return newUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(UserActionListener listener) {
        List<UserActionListener> list = listeners;
        synchronized (list) {
            listeners.add(listener);
        }
    }
}

