/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.oauth;

import enterprises.orbital.oauth.UserAccount;
import java.util.logging.Logger;

public class Auditor {
    public static final Logger log = Logger.getLogger(Auditor.class.getName());
    private static ThreadLocal<StringBuilder> builderPool = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };

    public static void audit(UserAccount user, Object ... info) {
        StringBuilder builder = builderPool.get();
        builder.setLength(0);
        builder.append("USER: [");
        if (user == null) {
            builder.append("INTERNAL");
        } else {
            builder.append(user.getUid());
        }
        builder.append("] AUDIT: ");
        for (int i = 0; i < info.length; ++i) {
            builder.append(String.valueOf(info[i]));
            builder.append(" ");
        }
        log.info(builder.toString());
    }
}

