/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scribe.builder.api.DefaultApi20;
import org.scribe.exceptions.OAuthException;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuth20ServiceImpl;
import org.scribe.oauth.OAuthService;
import org.scribe.utils.OAuthEncoder;
import org.scribe.utils.Preconditions;

public class Google2Api
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://accounts.google.com/o/oauth2/auth?response_type=code&client_id=%s&redirect_uri=%s";
    private static final String SCOPED_AUTHORIZE_URL = "https://accounts.google.com/o/oauth2/auth?response_type=code&client_id=%s&redirect_uri=%s&scope=%s";

    public String getAccessTokenEndpoint() {
        return "https://accounts.google.com/o/oauth2/token";
    }

    public AccessTokenExtractor getAccessTokenExtractor() {
        return new AccessTokenExtractor(){

            public Token extract(String response) {
                Preconditions.checkEmptyString((String)response, (String)"Response body is incorrect. Can't extract a token from an empty string");
                Matcher matcher = Pattern.compile("\"access_token\" : \"([^&\"]+)\"").matcher(response);
                if (matcher.find()) {
                    String token = OAuthEncoder.decode((String)matcher.group(1));
                    return new Token(token, "", response);
                }
                throw new OAuthException("Response body is incorrect. Can't extract a token from this: '" + response + "'", null);
            }
        };
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        if (config.hasScope()) {
            return String.format(SCOPED_AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()), OAuthEncoder.encode((String)config.getScope()));
        }
        return String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()));
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public OAuthService createService(OAuthConfig config) {
        return new GoogleOAuth2Service(this, config);
    }

    private class GoogleOAuth2Service
    extends OAuth20ServiceImpl {
        private static final String GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
        private static final String GRANT_TYPE = "grant_type";
        private DefaultApi20 api;
        private OAuthConfig config;

        public GoogleOAuth2Service(DefaultApi20 api, OAuthConfig config) {
            super(api, config);
            this.api = api;
            this.config = config;
        }

        public Token getAccessToken(Token requestToken, Verifier verifier) {
            OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
            switch (this.api.getAccessTokenVerb()) {
                case POST: {
                    request.addBodyParameter("client_id", this.config.getApiKey());
                    request.addBodyParameter("client_secret", this.config.getApiSecret());
                    request.addBodyParameter("code", verifier.getValue());
                    request.addBodyParameter("redirect_uri", this.config.getCallback());
                    request.addBodyParameter(GRANT_TYPE, GRANT_TYPE_AUTHORIZATION_CODE);
                    break;
                }
                default: {
                    request.addQuerystringParameter("client_id", this.config.getApiKey());
                    request.addQuerystringParameter("client_secret", this.config.getApiSecret());
                    request.addQuerystringParameter("code", verifier.getValue());
                    request.addQuerystringParameter("redirect_uri", this.config.getCallback());
                    if (!this.config.hasScope()) break;
                    request.addQuerystringParameter("scope", this.config.getScope());
                }
            }
            Response response = request.send();
            return this.api.getAccessTokenExtractor().extract(response.getBody());
        }
    }
}

