/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder.api;

import org.scribe.builder.api.DefaultApi20;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuth20ServiceImpl;
import org.scribe.services.Base64Encoder;

public class EVEOAuthServiceImpl
extends OAuth20ServiceImpl {
    private final DefaultApi20 api;
    private final OAuthConfig config;

    public EVEOAuthServiceImpl(DefaultApi20 api, OAuthConfig config) {
        super(api, config);
        this.api = api;
        this.config = config;
    }

    public Token getAccessToken(Token requestToken, Verifier verifier) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        String authorization = this.config.getApiKey() + ":" + this.config.getApiSecret();
        String encoded = Base64Encoder.getInstance().encode(authorization.getBytes());
        request.addHeader("Authorization", "Basic " + encoded);
        request.addQuerystringParameter("grant_type", "authorization_code");
        request.addQuerystringParameter("code", verifier.getValue());
        Response response = request.send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    public void signRequest(Token accessToken, OAuthRequest request) {
        request.addHeader("Authorization", "Bearer " + accessToken.getToken());
    }
}

