/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.builder.api;

import org.scribe.builder.api.DefaultApi20;
import org.scribe.builder.api.EVEOAuthServiceImpl;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.extractors.JsonTokenExtractor;
import org.scribe.model.OAuthConfig;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;
import org.scribe.utils.OAuthEncoder;

public class EVEApi
extends DefaultApi20 {
    protected String getAuthorizeURL() {
        return "https://login.eveonline.com/oauth/authorize/?response_type=code&client_id=%s&redirect_uri=%s";
    }

    protected String getScopedAuthorizeURL() {
        return this.getAuthorizeURL() + "&scope=%s";
    }

    public String getAccessTokenEndpoint() {
        return "https://login.eveonline.com/oauth/token";
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public AccessTokenExtractor getAccessTokenExtractor() {
        return new JsonTokenExtractor();
    }

    public String getAuthorizationUrl(OAuthConfig cfg) {
        if (cfg.hasScope()) {
            return String.format(this.getScopedAuthorizeURL(), cfg.getApiKey(), OAuthEncoder.encode((String)cfg.getCallback()), OAuthEncoder.encode((String)cfg.getScope()));
        }
        return String.format(this.getAuthorizeURL(), cfg.getApiKey(), OAuthEncoder.encode((String)cfg.getCallback()));
    }

    public OAuthService createService(OAuthConfig config) {
        return new EVEOAuthServiceImpl(this, config);
    }
}

