/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.oauth;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import enterprises.orbital.oauth.AuthUtil;
import enterprises.orbital.oauth.UserAccount;
import enterprises.orbital.oauth.UserAuthSource;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.TwitterApi;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class TwitterCallbackHandler {
    private static final Logger log = Logger.getLogger(TwitterCallbackHandler.class.getName());

    public static String doGet(String twitterApiKey, String twitterApiSecret, String standardRedirect, HttpServletRequest req) throws IOException {
        OAuthService service = new ServiceBuilder().provider(TwitterApi.Authenticate.class).apiKey(twitterApiKey).apiSecret(twitterApiSecret).build();
        Token requestToken = null;
        String caller = standardRedirect;
        try {
            requestToken = (Token)req.getSession().getAttribute("twitter_req_token");
            Verifier v = new Verifier(req.getParameter("oauth_verifier"));
            Token accessToken = service.getAccessToken(requestToken, v);
            OAuthRequest request = new OAuthRequest(Verb.GET, "https://api.twitter.com/1.1/account/verify_credentials.json");
            service.signRequest(accessToken, request);
            Response response = request.send();
            if (!response.isSuccessful()) {
                throw new IOException("credential request was not successful!");
            }
            UserAccount existing = AuthUtil.getCurrentUser(req);
            String screenName = (String)new Gson().fromJson(new JsonParser().parse(response.getBody()).getAsJsonObject().get("screen_name"), String.class);
            UserAuthSource sourceVal = AuthUtil.getBySourceScreenname("twitter", screenName);
            if (sourceVal != null) {
                if (existing != null) {
                    sourceVal.updateAccount(existing);
                    if (req.getSession().getAttribute("oe_addauth_redirect") != null) {
                        caller = (String)req.getSession().getAttribute("oe_addauth_redirect");
                        req.getSession().removeAttribute("oe_addauth_redirect");
                    }
                } else {
                    AuthUtil.signOn(req, sourceVal.getOwner(), sourceVal);
                }
            } else {
                UserAccount newUser = existing == null ? AuthUtil.createNewUserAccount(false) : existing;
                sourceVal = AuthUtil.createSource(newUser, "twitter", screenName, response.getBody());
                if (existing != null) {
                    if (req.getSession().getAttribute("oe_addauth_redirect") != null) {
                        caller = (String)req.getSession().getAttribute("oe_addauth_redirect");
                        req.getSession().removeAttribute("oe_addauth_redirect");
                    }
                } else {
                    AuthUtil.signOn(req, newUser, sourceVal);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed twitter authentication with error: ", e);
            caller = null;
        }
        return caller;
    }
}

