/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.oauth;

import enterprises.orbital.oauth.AuthUtil;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.TwitterApi;
import org.scribe.model.Token;
import org.scribe.oauth.OAuthService;

public class TwitterAuthHandler {
    private static final Logger log = Logger.getLogger(TwitterAuthHandler.class.getName());

    public static String doGet(String twitterApiKey, String twitterApiSecret, String callback, HttpServletRequest req) throws IOException {
        AuthUtil.prepAuthFlow(req);
        try {
            OAuthService service = new ServiceBuilder().provider(TwitterApi.Authenticate.class).apiKey(twitterApiKey).apiSecret(twitterApiSecret).callback(callback).build();
            Token requestToken = service.getRequestToken();
            req.getSession().setAttribute("twitter_req_token", (Object)requestToken);
            return service.getAuthorizationUrl(requestToken);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error attempting twitter authentication", e);
            return null;
        }
    }
}

