/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.oauth;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import enterprises.orbital.oauth.AuthUtil;
import enterprises.orbital.oauth.UserAccount;
import enterprises.orbital.oauth.UserAuthSource;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Google2Api;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class GoogleCallbackHandler {
    private static final Logger log = Logger.getLogger(GoogleCallbackHandler.class.getName());

    public static String doGet(String googleApiKey, String googleApiSecret, String googleScope, String redirectCallback, String standardRedirect, HttpServletRequest req) throws IOException {
        OAuthService service = new ServiceBuilder().provider(Google2Api.class).apiKey(googleApiKey).scope(googleScope).apiSecret(googleApiSecret).callback(redirectCallback).build();
        String caller = standardRedirect;
        try {
            Verifier v = new Verifier(req.getParameter("code"));
            Token accessToken = service.getAccessToken(Token.empty(), v);
            OAuthRequest request = new OAuthRequest(Verb.GET, "https://www.googleapis.com/oauth2/v2/userinfo?alt=json");
            service.signRequest(accessToken, request);
            Response response = request.send();
            if (!response.isSuccessful()) {
                throw new IOException("credential request was not successful!");
            }
            UserAccount existing = AuthUtil.getCurrentUser(req);
            String screenName = (String)new Gson().fromJson(new JsonParser().parse(response.getBody()).getAsJsonObject().get("email"), String.class);
            UserAuthSource sourceVal = AuthUtil.getBySourceScreenname("google", screenName);
            if (sourceVal != null) {
                if (existing != null) {
                    sourceVal.updateAccount(existing);
                    if (req.getSession().getAttribute("oe_addauth_redirect") != null) {
                        caller = (String)req.getSession().getAttribute("oe_addauth_redirect");
                        req.getSession().removeAttribute("oe_addauth_redirect");
                    }
                } else {
                    AuthUtil.signOn(req, sourceVal.getOwner(), sourceVal);
                }
            } else {
                UserAccount newUser = existing == null ? AuthUtil.createNewUserAccount(false) : existing;
                sourceVal = AuthUtil.createSource(newUser, "google", screenName, response.getBody());
                if (existing != null) {
                    if (req.getSession().getAttribute("oe_addauth_redirect") != null) {
                        caller = (String)req.getSession().getAttribute("oe_addauth_redirect");
                        req.getSession().removeAttribute("oe_addauth_redirect");
                    }
                } else {
                    AuthUtil.signOn(req, newUser, sourceVal);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed google authentication with error: ", e);
            caller = null;
        }
        return caller;
    }
}

