/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.oauth;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import enterprises.orbital.oauth.AuthUtil;
import enterprises.orbital.oauth.UserAccount;
import enterprises.orbital.oauth.UserAuthSource;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class EVECallbackHandler {
    private static final Logger log = Logger.getLogger(EVECallbackHandler.class.getName());

    public static String doGet(Class<? extends Api> apiClass, String clientID, String secretKey, String verifyURL, String callback, HttpServletRequest req) throws IOException {
        OAuthService service = new ServiceBuilder().provider(apiClass).apiKey(clientID).apiSecret(secretKey).build();
        try {
            Verifier v = new Verifier(req.getParameter("code"));
            Token accessToken = service.getAccessToken(null, v);
            OAuthRequest request = new OAuthRequest(Verb.GET, verifyURL);
            service.signRequest(accessToken, request);
            Response response = request.send();
            if (!response.isSuccessful()) {
                throw new IOException("credential request was not successful!");
            }
            UserAccount existing = AuthUtil.getCurrentUser(req);
            String charName = (String)new Gson().fromJson(new JsonParser().parse(response.getBody()).getAsJsonObject().get("CharacterName"), String.class);
            UserAuthSource sourceVal = AuthUtil.getBySourceScreenname("eve", charName);
            if (sourceVal != null) {
                if (existing != null) {
                    sourceVal.updateAccount(existing);
                    if (req.getSession().getAttribute("oe_addauth_redirect") != null) {
                        callback = (String)req.getSession().getAttribute("oe_addauth_redirect");
                        req.getSession().removeAttribute("oe_addauth_redirect");
                    }
                } else {
                    AuthUtil.signOn(req, sourceVal.getOwner(), sourceVal);
                }
            } else {
                UserAccount newUser = existing == null ? AuthUtil.createNewUserAccount(false) : existing;
                sourceVal = AuthUtil.createSource(newUser, "eve", charName, response.getBody());
                if (existing != null) {
                    if (req.getSession().getAttribute("oe_addauth_redirect") != null) {
                        callback = (String)req.getSession().getAttribute("oe_addauth_redirect");
                        req.getSession().removeAttribute("oe_addauth_redirect");
                    }
                } else {
                    AuthUtil.signOn(req, newUser, sourceVal);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed EVE authentication with error: ", e);
            callback = null;
        }
        return callback;
    }
}

