/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.corporation.Fuel;
import enterprises.orbital.evekit.model.corporation.Starbase;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class StarbaseSheetWriter {
    private StarbaseSheetWriter() {
    }

    private static List<Long> dumpFuel(SynchronizedEveAccount acct, ZipOutputStream stream, List<Long> stationIDs, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("StarbaseFuel.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Starbase ID", "Type ID", "Quantity"});
        for (long stationID : stationIDs) {
            List batch = CachedData.retrieveAll((long)at, (contid, at1) -> Fuel.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.values((Object[])new Object[]{stationID}), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
            if (batch.size() <= 0) continue;
            for (Fuel next : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getStarbaseID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getQuantity(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                itemIDs.add(next.getCid());
            }
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Starbases.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Starbase ID", "Type ID", "System ID", "Moon ID", "State", "Unanchor At (Raw)", "Unanchor At", "Reinforced Until (Raw)", "Reinforced Until", "Onlined Since (Raw)", "Onlined Since", "Fuel Bay View", "Fuel Bay Take", "Anchor", "Unanchor", "Online", "Offline", "Allow Corporation Members", "Allow Alliance Members", "Use Alliance Standings", "Attack Standing Threshold", "Attack Security Status Threshold", "Attack If Other Security Status Dropping", "Attack If At War"});
        List batch = CachedData.retrieveAll((long)at, (contid, at1) -> Starbase.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        ArrayList<Long> starbaseIDs = new ArrayList<Long>();
        for (Starbase next : batch) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getStarbaseID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSystemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getMoonID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getState(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getUnanchorAt(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getUnanchorAt()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getReinforcedUntil(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getReinforcedUntil()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getOnlinedSince(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getOnlinedSince()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getFuelBayView(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getFuelBayTake(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getAnchor(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getUnanchor(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getOnline(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getOffline(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.isAllowCorporationMembers(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.isAllowAllianceMembers(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.isUseAllianceStandings(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(Float.valueOf(next.getAttackStandingThreshold()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(Float.valueOf(next.getAttackSecurityStatusThreshold()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.isAttackIfOtherSecurityStatusDropping(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.isAttackIfAtWar(), SheetUtils.CellFormat.NO_STYLE));
            starbaseIDs.add(next.getStarbaseID());
        }
        output.flush();
        stream.closeEntry();
        if (batch.size() > 0) {
            output = SheetUtils.prepForMetaData("StarbasesMeta.csv", stream, false, null);
            for (Starbase next : batch) {
                int count = SheetUtils.dumpNextMetaData(acct, output, next.getCid(), "Starbase");
                if (count <= 0) continue;
                output.println();
            }
            output.flush();
            stream.closeEntry();
            List<Long> writes = StarbaseSheetWriter.dumpFuel(acct, stream, starbaseIDs, at);
            if (writes.size() > 0) {
                output = SheetUtils.prepForMetaData("StarbaseFuelMeta.csv", stream, false, null);
                for (Long next : writes) {
                    int count = SheetUtils.dumpNextMetaData(acct, output, next, "Fuel");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
        }
    }
}

