/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.corporation.MiningExtraction;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MiningExtractionSheetWriter {
    private MiningExtractionSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MiningExtraction.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Moon ID", "Structure ID", "Extraction Start Time (Raw)", "Extraction Start Time", "Chunk Arrival Time (Raw)", "Chunk Arrival Time", "Natural Decay Time (Raw)", "Natural Decay Time"});
        List points = CachedData.retrieveAll((long)at, (contid, at1) -> MiningExtraction.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        for (MiningExtraction next : points) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getMoonID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getStructureID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getExtractionStartTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getExtractionStartTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getChunkArrivalTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getChunkArrivalTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getNaturalDecayTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getNaturalDecayTime()), SheetUtils.CellFormat.DATE_STYLE));
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MiningExtractionMeta.csv", stream, false, null);
        for (MiningExtraction next : points) {
            int count = SheetUtils.dumpNextMetaData(acct, output, next.getCid(), "MiningExtraction");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

