/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.corporation.MemberTracking;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MemberTrackingSheetWriter {
    private MemberTrackingSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MemberTracking.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Character ID", "Base ID", "Location ID", "Logoff Date Time (Raw)", "Logoff Date Time", "Logon Date Time (Raw)", "Logon Date Time", "Ship Type ID", "Start Date Time (Raw)", "Start Date Time"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List batch = CachedData.retrieveAll((long)at, (contid, at1) -> MemberTracking.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        for (MemberTracking memberTracking : batch) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(memberTracking.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberTracking.getCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberTracking.getBaseID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberTracking.getLocationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberTracking.getLogoffDateTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(memberTracking.getLogoffDateTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(memberTracking.getLogonDateTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(memberTracking.getLogonDateTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(memberTracking.getShipTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberTracking.getStartDateTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(memberTracking.getStartDateTime()), SheetUtils.CellFormat.DATE_STYLE));
            metaIDs.add(memberTracking.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MemberTrackingMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "MemberTracking");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

