/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.corporation.Member;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MemberSheetWriter {
    private MemberSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Members.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Character ID"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List batch = CachedData.retrieveAll((long)at, (contid, at1) -> Member.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any()));
        for (Member member : batch) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(member.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(member.getCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            metaIDs.add(member.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MembersMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "Member");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

