/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.corporation.MemberRole;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MemberRoleSheetWriter {
    private MemberRoleSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MemberRoles.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Character ID", "Role Name", "Grantable?", "At HQ?", "At Base?", "At Other?"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List batch = CachedData.retrieveAll((long)at, (contid, at1) -> MemberRole.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        for (MemberRole memberRole : batch) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(memberRole.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberRole.getCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(memberRole.getRoleName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberRole.isGrantable(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberRole.isAtHQ(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberRole.isAtBase(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(memberRole.isAtOther(), SheetUtils.CellFormat.NO_STYLE));
            metaIDs.add(memberRole.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MemberRolesMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "MemberRole");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

