/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.corporation.MemberRoleHistory;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MemberRoleHistorySheetWriter {
    private MemberRoleHistorySheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MemberRoleHistory.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Character ID", "Changed At (Raw)", "Changed At", "Issuer ID", "Role Type", "Role Name", "Old?"});
        ArrayList metaIDs = new ArrayList();
        CachedData.SimpleStreamExceptionHandler capture = new CachedData.SimpleStreamExceptionHandler();
        CachedData.stream((long)at, (contid, ats) -> MemberRoleHistory.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()), (boolean)true, (CachedData.StreamExceptionHandler)capture).forEach(next -> {
            try {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getChangedAt(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getChangedAt()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getIssuerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getRoleType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getRoleName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.isOld(), SheetUtils.CellFormat.NO_STYLE));
            }
            catch (IOException e) {
                capture.handle(e);
            }
            metaIDs.add(next.getCid());
        });
        output.flush();
        stream.closeEntry();
        CSVPrinter metaOutput = SheetUtils.prepForMetaData("MemberRoleHistoryMeta.csv", stream, false, null);
        for (Long next2 : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, metaOutput, next2, "MemberRoleHistory");
            if (count <= 0) continue;
            metaOutput.println();
        }
        metaOutput.flush();
        stream.closeEntry();
    }
}

