/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.corporation.CustomsOffice;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CustomsOfficesSheetWriter {
    private CustomsOfficesSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("CustomsOffices.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Office ID", "Solar System ID", "Reinforce Exit Start", "Reinforce Exit End", "Allow Alliance", "Allow Standings", "Standing Level", "Tax Rate Alliance", "Tax Rate Corp", "Tax Rate Standing Excellent", "Tax Rate Standing Good", "Tax Rate Standing Neutral", "Tax Rate Standing Bad", "Tax Rate Standing Terrible"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List offices = CachedData.retrieveAll((long)at, (contid, at1) -> CustomsOffice.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        for (CustomsOffice customsOffice : offices) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(customsOffice.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(customsOffice.getOfficeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(customsOffice.getSolarSystemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(customsOffice.getReinforceExitStart(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(customsOffice.getReinforceExitEnd(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(customsOffice.isAllowAlliance(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(customsOffice.isAllowStandings(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(customsOffice.getStandingLevel(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(Float.valueOf(customsOffice.getTaxRateAlliance()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(Float.valueOf(customsOffice.getTaxRateCorp()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(Float.valueOf(customsOffice.getTaxRateStandingExcellent()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(Float.valueOf(customsOffice.getTaxRateStandingGood()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(Float.valueOf(customsOffice.getTaxRateStandingNeutral()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(Float.valueOf(customsOffice.getTaxRateStandingBad()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(Float.valueOf(customsOffice.getTaxRateStandingTerrible()), SheetUtils.CellFormat.DOUBLE_STYLE));
            metaIDs.add(customsOffice.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("CustomsOfficesMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "CustomsOffice");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

