/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.CorporationSheet;
import enterprises.orbital.evekit.model.corporation.MemberLimit;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CorporationSheetSheetWriter {
    private CorporationSheetSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("CorporationSheet.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Alliance ID", "Ceo ID", "Corporation ID", "Corporation Name", "Description", "Member Count", "Shares", "Station ID", "Tax Rate", "Ticker", "Url", "Date Founded (Raw)", "Date Founded", "Creator ID", "Faction ID", "px64x64", "px128x128", "px256x256"});
        CorporationSheet csheet = CorporationSheet.get((SynchronizedEveAccount)acct, (long)at);
        if (csheet != null) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(csheet.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getAllianceID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getCeoID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getCorporationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getCorporationName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getDescription(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getMemberCount(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getShares(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getStationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(Float.valueOf(csheet.getTaxRate()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(csheet.getTicker(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getUrl(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getDateFounded(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getDateFounded()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(csheet.getCreatorID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getFactionID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getPx64x64(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getPx128x128(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getPx256x256(), SheetUtils.CellFormat.NO_STYLE));
            output.flush();
            stream.closeEntry();
            output = SheetUtils.prepForMetaData("CorporationSheetMeta.csv", stream, false, null);
            SheetUtils.dumpNextMetaData(acct, output, csheet.getCid(), "CorporationSheet");
        }
        output.flush();
        stream.closeEntry();
        stream.putNextEntry(new ZipEntry("MemberLimit.csv"));
        output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Limit"});
        MemberLimit limit = MemberLimit.get((SynchronizedEveAccount)acct, (long)at);
        if (limit != null) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(limit.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(limit.getMemberLimit(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            output.flush();
            stream.closeEntry();
            output = SheetUtils.prepForMetaData("MemberLimitMeta.csv", stream, false, null);
            SheetUtils.dumpNextMetaData(acct, output, limit.getCid(), "MemberLimit");
        }
        output.flush();
        stream.closeEntry();
    }
}

