/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.corporation.ContainerLog;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ContainerLogSheetWriter {
    private ContainerLogSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("ContainerLogs.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Log Time (Raw)", "Log Time", "Action", "Character ID", "Location Flag", "Container ID", "Container Type ID", "Location ID", "New Configuration", "Old Configuration", "Password Type", "Quantity", "Type ID"});
        ArrayList metaIDs = new ArrayList();
        CachedData.SimpleStreamExceptionHandler capture = new CachedData.SimpleStreamExceptionHandler();
        CachedData.stream((long)at, (contid, ats) -> ContainerLog.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()), (boolean)true, (CachedData.StreamExceptionHandler)capture).forEach(next -> {
            try {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getLogTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getLogTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getAction(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLocationFlag(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getContainerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getContainerTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLocationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getNewConfiguration(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getOldConfiguration(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getPasswordType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getQuantity(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            }
            catch (IOException e) {
                capture.handle(e);
            }
            metaIDs.add(next.getCid());
        });
        output.flush();
        stream.closeEntry();
        CSVPrinter metaOutput = SheetUtils.prepForMetaData("ContainerLogsMeta.csv", stream, false, null);
        for (Long next2 : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, metaOutput, next2, "ContainerLog");
            if (count <= 0) continue;
            metaOutput.println();
        }
        metaOutput.flush();
        stream.closeEntry();
    }
}

