/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.common.WalletJournal;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class WalletJournalSheetWriter {
    private WalletJournalSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("WalletJournal.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Division", "Ref ID", "Date (Raw)", "Date", "Ref Type", "First Party ID", "Second Party ID", "Arg Name 1", "Arg ID 1", "Amount", "Balance", "Reason", "Tax Receiver ID", "Tax Amount", "Context ID", "Context Type", "Description"});
        ArrayList metaIDs = new ArrayList();
        CachedData.SimpleStreamExceptionHandler capture = new CachedData.SimpleStreamExceptionHandler();
        CachedData.stream((long)at, (contid, at1) -> WalletJournal.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()), (boolean)true, (CachedData.StreamExceptionHandler)capture).forEach(next -> {
            try {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getDivision(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getRefID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getRefType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getFirstPartyID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSecondPartyID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getArgName1(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getArgID1(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getAmount(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(next.getBalance(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(next.getReason(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getTaxReceiverID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTaxAmount(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(next.getContextID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getContextType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getDescription(), SheetUtils.CellFormat.NO_STYLE));
                if (next.hasMetaData()) {
                    metaIDs.add(next.getCid());
                }
            }
            catch (IOException e) {
                capture.handle(e);
            }
        });
        output.flush();
        stream.closeEntry();
        CSVPrinter metaOutput = SheetUtils.prepForMetaData("WalletJournalMeta.csv", stream, false, null);
        for (Long next2 : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, metaOutput, next2, "WalletJournal");
            if (count <= 0) continue;
            metaOutput.println();
        }
        metaOutput.flush();
        stream.closeEntry();
    }
}

