/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.common.Location;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class LocationSheetWriter {
    private LocationSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Locations.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Item ID", "Item Name", "X", "Y", "Z"});
        ArrayList locations = new ArrayList();
        long contid = -1L;
        List batch = Location.getAllLocations((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            locations.addAll(batch);
            contid = ((Location)batch.get(batch.size() - 1)).getItemID();
            batch = Location.getAllLocations((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        for (Location next : locations) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getItemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getItemName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getX(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getY(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getZ(), SheetUtils.CellFormat.DOUBLE_STYLE));
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("LocationsMeta.csv", stream, false, null);
        for (Location next : locations) {
            int count = SheetUtils.dumpNextMetaData(acct, output, next.getCid(), "Location");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

