/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.common.Kill;
import enterprises.orbital.evekit.model.common.KillAttacker;
import enterprises.orbital.evekit.model.common.KillItem;
import enterprises.orbital.evekit.model.common.KillVictim;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class KillSheetWriter {
    private KillSheetWriter() {
    }

    private static List<Long> dumpKillAttackers(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("KillAttackers.csv"));
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Kill ID", "Attacker Character ID", "Alliance ID", "Attacker Corporation ID", "Damage Done", "Faction ID", "Security Status", "Ship Type ID", "Weapon Type ID", "Final Blow"});
        CachedData.SimpleStreamExceptionHandler capture = new CachedData.SimpleStreamExceptionHandler();
        CachedData.stream((long)at, (contid, ats) -> KillAttacker.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()), (boolean)true, (CachedData.StreamExceptionHandler)capture).forEach(next -> {
            try {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getKillID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getAttackerCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getAllianceID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getAttackerCorporationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getDamageDone(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getFactionID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(Float.valueOf(next.getSecurityStatus()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getShipTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getWeaponTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.isFinalBlow(), SheetUtils.CellFormat.NO_STYLE));
            }
            catch (IOException e) {
                capture.handle(e);
            }
            metaIDs.add(next.getCid());
        });
        output.flush();
        stream.closeEntry();
        return metaIDs;
    }

    private static List<Long> dumpKillItems(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("KillItems.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Kill ID", "Type ID", "Flag", "Quantity Destroyed", "Quantity Dropped", "Singleton", "Container", "Sequence"});
        CachedData.SimpleStreamExceptionHandler capture = new CachedData.SimpleStreamExceptionHandler();
        CachedData.stream((long)at, (contid, ats) -> KillItem.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()), (boolean)true, (CachedData.StreamExceptionHandler)capture).forEach(next -> {
            try {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getKillID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getFlag(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getQtyDestroyed(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getQtyDropped(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSingleton(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getContainerSequence(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSequence(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            }
            catch (IOException e) {
                capture.handle(e);
            }
            metaIDs.add(next.getCid());
        });
        output.flush();
        stream.closeEntry();
        return metaIDs;
    }

    private static List<Long> dumpKillVictims(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("KillVictims.csv"));
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Kill ID", "Alliance ID", "Kill Character ID", "Kill Corporation ID", "Damage Taken", "Faction ID", "Faction Name", "Ship Type ID", "X", "Y", "Z"});
        CachedData.SimpleStreamExceptionHandler capture = new CachedData.SimpleStreamExceptionHandler();
        CachedData.stream((long)at, (contid, ats) -> KillVictim.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()), (boolean)true, (CachedData.StreamExceptionHandler)capture).forEach(next -> {
            try {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getKillID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getAllianceID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getKillCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getKillCorporationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getDamageTaken(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getFactionID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getShipTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            }
            catch (IOException e) {
                capture.handle(e);
            }
            metaIDs.add(next.getCid());
        });
        output.flush();
        stream.closeEntry();
        return metaIDs;
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Kills.csv"));
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Kill ID", "Kill Time (Raw)", "Kill Time", "Moon ID", "Solar System ID"});
        CachedData.SimpleStreamExceptionHandler capture = new CachedData.SimpleStreamExceptionHandler();
        CachedData.stream((long)at, (contid, ats) -> Kill.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()), (boolean)true, (CachedData.StreamExceptionHandler)capture).forEach(next -> {
            try {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getKillID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getKillTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getKillTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getMoonID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSolarSystemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            }
            catch (IOException e) {
                capture.handle(e);
            }
            metaIDs.add(next.getCid());
        });
        output.flush();
        stream.closeEntry();
        if (!metaIDs.isEmpty()) {
            int count;
            output = SheetUtils.prepForMetaData("KillsMeta.csv", stream, false, null);
            for (Long next2 : metaIDs) {
                count = SheetUtils.dumpNextMetaData(acct, output, next2, "Kill");
                if (count <= 0) continue;
                output.println();
            }
            output.flush();
            stream.closeEntry();
            metaIDs.clear();
            metaIDs.addAll(KillSheetWriter.dumpKillAttackers(acct, stream, at));
            if (!metaIDs.isEmpty()) {
                output = SheetUtils.prepForMetaData("KillAttackersMeta.csv", stream, false, null);
                for (Long next2 : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, next2, "KillAttacker");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
            metaIDs.clear();
            metaIDs.addAll(KillSheetWriter.dumpKillItems(acct, stream, at));
            if (!metaIDs.isEmpty()) {
                output = SheetUtils.prepForMetaData("KillItemsMeta.csv", stream, false, null);
                for (Long next2 : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, next2, "KillItem");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
            metaIDs.clear();
            metaIDs.addAll(KillSheetWriter.dumpKillVictims(acct, stream, at));
            if (!metaIDs.isEmpty()) {
                output = SheetUtils.prepForMetaData("KillVictimsMeta.csv", stream, false, null);
                for (Long next2 : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, next2, "KillVictim");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
        }
    }
}

