/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.common.Contract;
import enterprises.orbital.evekit.model.common.ContractBid;
import enterprises.orbital.evekit.model.common.ContractItem;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ContractSheetWriter {
    private ContractSheetWriter() {
    }

    private static List<Long> dumpContractItems(SynchronizedEveAccount acct, ZipOutputStream stream, List<Contract> contracts, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("ContractItems.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Contract ID", "Record ID", "Type ID", "Quantity", "Raw Quantity", "Singleton", "Included"});
        for (Contract nextContract : contracts) {
            int contractID = nextContract.getContractID();
            List allItems = CachedData.retrieveAll((long)at, (contid, ats) -> ContractItem.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)AttributeSelector.values((Object[])new Object[]{contractID}), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
            if (allItems.isEmpty()) continue;
            for (ContractItem next : allItems) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getContractID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getRecordID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getQuantity(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getRawQuantity(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.isSingleton(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.isIncluded(), SheetUtils.CellFormat.NO_STYLE));
            }
            itemIDs.addAll(allItems.stream().map(CachedData::getCid).collect(Collectors.toList()));
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    private static List<Long> dumpContractBids(SynchronizedEveAccount acct, ZipOutputStream stream, List<Contract> contracts, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("ContractBids.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Bid ID", "Contract ID", "Bidder ID", "Date Bid (Raw)", "Date Bid", "Amount"});
        for (Contract nextContract : contracts) {
            int contractID = nextContract.getContractID();
            List allBids = CachedData.retrieveAll((long)at, (contid, ats) -> ContractBid.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.values((Object[])new Object[]{contractID}), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
            if (allBids.isEmpty()) continue;
            for (ContractBid next : allBids) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getBidID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getContractID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getBidderID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getDateBid(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getDateBid()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getAmount(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE));
            }
            itemIDs.addAll(allBids.stream().map(CachedData::getCid).collect(Collectors.toList()));
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Contracts.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Contract ID", "Issuer ID", "Issuer Corp ID", "Assignee ID", "Acceptor ID", "Start Station ID", "End Station ID", "Type", "Status", "Title", "For Corp", "Availability", "Date Issued (Raw)", "Date Issued", "Date Expired (Raw)", "Date Expired", "Date Accepted (Raw)", "Date Accepted", "Num Days", "Date Completed (Raw)", "Date Completed", "Price", "Reward", "Collateral", "Buyout", "Volume"});
        List contracts = CachedData.retrieveAll((long)at, (contid, ats) -> Contract.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        for (Contract next : contracts) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getContractID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getIssuerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getIssuerCorpID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getAssigneeID(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getAcceptorID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getStartStationID(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getEndStationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getStatus(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getTitle(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.isForCorp(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getAvailability(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getDateIssued(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getDateIssued()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getDateExpired(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getDateExpired()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getDateAccepted(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getDateAccepted()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getNumDays(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getDateCompleted(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getDateCompleted()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getPrice(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(next.getReward(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(next.getCollateral(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(next.getBuyout(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(next.getVolume(), SheetUtils.CellFormat.DOUBLE_STYLE));
        }
        output.flush();
        stream.closeEntry();
        if (contracts.size() > 0) {
            int count;
            output = SheetUtils.prepForMetaData("ContractsMeta.csv", stream, false, null);
            for (Contract next : contracts) {
                int count2 = SheetUtils.dumpNextMetaData(acct, output, next.getCid(), "Contract");
                if (count2 <= 0) continue;
                output.println();
            }
            output.flush();
            stream.closeEntry();
            List<Long> writes = ContractSheetWriter.dumpContractItems(acct, stream, contracts, at);
            if (writes.size() > 0) {
                output = SheetUtils.prepForMetaData("ContractItemsMeta.csv", stream, false, null);
                for (Long next : writes) {
                    count = SheetUtils.dumpNextMetaData(acct, output, next, "ContractItem");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
            if ((writes = ContractSheetWriter.dumpContractBids(acct, stream, contracts, at)).size() > 0) {
                output = SheetUtils.prepForMetaData("ContractBidsMeta.csv", stream, false, null);
                for (Long next : writes) {
                    count = SheetUtils.dumpNextMetaData(acct, output, next, "ContractBid");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
        }
    }
}

