/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.common.Contact;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ContactSheetWriter {
    private ContactSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Contacts.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "List", "Contact ID", "Standing", "Contact Type", "In Watch List", "Is Blocked", "Label ID"});
        List contacts = CachedData.retrieveAll((long)at, (contid, at1) -> Contact.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        for (Contact next : contacts) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getList(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getContactID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(Float.valueOf(next.getStanding()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getContactType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.isInWatchlist(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.isBlocked(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getLabelID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("ContactsMeta.csv", stream, false, null);
        for (Contact next : contacts) {
            int count = SheetUtils.dumpNextMetaData(acct, output, next.getCid(), "Contact");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

