/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.common.Bookmark;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class BookmarkSheetWriter {
    private BookmarkSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Bookmarks.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Folder ID", "Folder Name", "Folder Creator ID", "Bookmark ID", "Bookmark Creator ID", "Created (Raw)", "Created", "Item ID", "Type ID", "Location ID", "X", "Y", "Z", "Memo", "Note"});
        ArrayList metaIDs = new ArrayList();
        CachedData.SimpleStreamExceptionHandler capture = new CachedData.SimpleStreamExceptionHandler();
        CachedData.stream((long)at, (contid, ats) -> Bookmark.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()), (boolean)true, (CachedData.StreamExceptionHandler)capture).forEach(next -> {
            try {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getFolderID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getFolderName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getFolderCreatorID(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getBookmarkID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getBookmarkCreatorID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getCreated(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getCreated()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getItemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLocationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getX(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getY(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getZ(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getMemo(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getNote(), SheetUtils.CellFormat.NO_STYLE));
            }
            catch (IOException e) {
                capture.handle(e);
            }
            metaIDs.add(next.getCid());
        });
        output.flush();
        stream.closeEntry();
        CSVPrinter metaOutput = SheetUtils.prepForMetaData("BookmarksMeta.csv", stream, false, null);
        for (Long next2 : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, metaOutput, next2, "Bookmark");
            if (count <= 0) continue;
            output.println();
        }
        metaOutput.flush();
        stream.closeEntry();
    }
}

