/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.common.Blueprint;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class BlueprintSheetWriter {
    private BlueprintSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Blueprints.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Item ID", "Location ID", "Location Flag", "Type ID", "Quantity", "Time Efficiency", "Material Efficiency", "Runs"});
        ArrayList blueprints = new ArrayList();
        long contid = -1L;
        List batch = Blueprint.getAllBlueprints((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            blueprints.addAll(batch);
            contid = ((Blueprint)batch.get(batch.size() - 1)).getItemID();
            batch = Blueprint.getAllBlueprints((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        for (Blueprint next : blueprints) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getItemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLocationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLocationFlag(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getQuantity(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getTimeEfficiency(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getMaterialEfficiency(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getRuns(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("BlueprintsMeta.csv", stream, false, null);
        for (Blueprint next : blueprints) {
            int count = SheetUtils.dumpNextMetaData(acct, output, next.getCid(), "Blueprint");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

