/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.character.SkillInQueue;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class SkillsInQueueSheetWriter {
    private SkillsInQueueSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("SkillsInQueue.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Type ID", "Queue Position", "Level", "Start SP", "Start Time (Raw)", "Start Time", "End SP", "End Time (Raw)", "End Time", "Training Start SP"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List skill = CachedData.retrieveAll((long)at, (contid, at1) -> SkillInQueue.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        for (SkillInQueue skillInQueue : skill) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(skillInQueue.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(skillInQueue.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(skillInQueue.getQueuePosition(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(skillInQueue.getLevel(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(skillInQueue.getStartSP(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(skillInQueue.getStartTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(skillInQueue.getStartTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(skillInQueue.getEndSP(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(skillInQueue.getEndTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(skillInQueue.getEndTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(skillInQueue.getTrainingStartSP(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            metaIDs.add(skillInQueue.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("SkillsInQueueMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "SkillInQueue");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

