/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.character.ResearchAgent;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ResearchAgentSheetWriter {
    private ResearchAgentSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("ResearchAgents.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Agent ID", "Points Per Day", "Remainder Points", "Research Start Date (Raw)", "Research Start Date", "Skill Type ID"});
        List<Object> batch = SheetUtils.retrieveAll(at, (ctid, tm) -> ResearchAgent.accessQuery((SynchronizedEveAccount)acct, (long)ctid, (int)1000, (boolean)false, (AttributeSelector)tm, (AttributeSelector)SheetUtils.ANY_SELECTOR, (AttributeSelector)SheetUtils.ANY_SELECTOR, (AttributeSelector)SheetUtils.ANY_SELECTOR, (AttributeSelector)SheetUtils.ANY_SELECTOR, (AttributeSelector)SheetUtils.ANY_SELECTOR));
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        for (ResearchAgent researchAgent : batch) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(researchAgent.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(researchAgent.getAgentID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(Float.valueOf(researchAgent.getPointsPerDay()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(Float.valueOf(researchAgent.getRemainderPoints()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(researchAgent.getResearchStartDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(researchAgent.getResearchStartDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(researchAgent.getSkillTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            metaIDs.add(researchAgent.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("ResearchAgentsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "ResearchAgent");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

