/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.character.PlanetaryColony;
import enterprises.orbital.evekit.model.character.PlanetaryLink;
import enterprises.orbital.evekit.model.character.PlanetaryPin;
import enterprises.orbital.evekit.model.character.PlanetaryRoute;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class PlanetaryColoniesSheetWriter {
    private PlanetaryColoniesSheetWriter() {
    }

    private static List<Long> dumpPlanetaryPins(SynchronizedEveAccount acct, ZipOutputStream stream, List<Integer> planets, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("PlanetaryPins.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Planet ID", "Pin ID", "Type ID", "Schematic ID", "Last Cycle Start (Raw)", "Last Cycle Start", "Cycle Time", "Quantity Per Cycle", "Install Time (Raw)", "Install Time", "Expiry Time (Raw)", "Expiry Time", "Product Type ID", "Longitude", "Latitude", "Head Radius", "Heads", "Contents"});
        for (int planetID : planets) {
            List allPins = CachedData.retrieveAll((long)at, (contid, at1) -> PlanetaryPin.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.values((Object[])new Object[]{planetID}), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
            for (PlanetaryPin next : allPins) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getPlanetID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getPinID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSchematicID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLastCycleStart(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getLastCycleStart()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getCycleTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getQuantityPerCycle(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getInstallTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getInstallTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getExpiryTime(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getExpiryTime()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getProductTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(Float.valueOf(next.getLongitude()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(Float.valueOf(next.getLatitude()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(Float.valueOf(next.getHeadRadius()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(Arrays.toString(next.getHeads().stream().map(x -> "[" + x.getHeadID() + ", " + x.getLongitude() + ", " + x.getLatitude() + "]").toArray(String[]::new)), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(Arrays.toString(next.getContents().stream().map(x -> "[" + x.getTypeID() + ", " + x.getAmount() + "]").toArray(String[]::new)), SheetUtils.CellFormat.NO_STYLE));
                if (!next.hasMetaData()) continue;
                itemIDs.add(next.getCid());
            }
            if (allPins.size() <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    private static List<Long> dumpPlanetaryLinks(SynchronizedEveAccount acct, ZipOutputStream stream, List<Integer> planets, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("PlanetaryLinks.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Planet ID", "Source Pin ID", "Destination Pin ID", "Link Level"});
        for (int planetID : planets) {
            List allLinks = CachedData.retrieveAll((long)at, (contid, at1) -> PlanetaryLink.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.values((Object[])new Object[]{planetID}), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
            for (PlanetaryLink next : allLinks) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getPlanetID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSourcePinID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getDestinationPinID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLinkLevel(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                if (!next.hasMetaData()) continue;
                itemIDs.add(next.getCid());
            }
            if (allLinks.size() <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    private static List<Long> dumpPlanetaryRoutes(SynchronizedEveAccount acct, ZipOutputStream stream, List<Integer> planets, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("PlanetaryRoutes.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Planet ID", "Route ID", "Source Pin ID", "Destination Pin ID", "Content Type ID", "Quantity", "Waypoints"});
        for (int planetID : planets) {
            List allRoutes = CachedData.retrieveAll((long)at, (contid, at1) -> PlanetaryRoute.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.values((Object[])new Object[]{planetID}), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
            for (PlanetaryRoute next : allRoutes) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getPlanetID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getRouteID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSourcePinID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getDestinationPinID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getContentTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(Float.valueOf(next.getQuantity()), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(Arrays.toString((Object[])next.getWaypoints().toArray(new Long[next.getWaypoints().size()])), SheetUtils.CellFormat.NO_STYLE));
                if (!next.hasMetaData()) continue;
                itemIDs.add(next.getCid());
            }
            if (allRoutes.size() <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("PlanetaryColonies.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Planet ID", "Solar System ID", "Planet Type", "Owner ID", "Last Update (Raw)", "Last Update", "Upgrade Level", "Number Of Pins"});
        ArrayList<Integer> planetIDs = new ArrayList<Integer>();
        List<Object> metaIDs = new ArrayList();
        List batch = CachedData.retrieveAll((long)at, (contid, at1) -> PlanetaryColony.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        for (Object next : batch) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getPlanetID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getSolarSystemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getPlanetType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getOwnerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLastUpdate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getLastUpdate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getUpgradeLevel(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getNumberOfPins(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            planetIDs.add(next.getPlanetID());
            if (!next.hasMetaData()) continue;
            metaIDs.add(next.getCid());
        }
        output.flush();
        stream.closeEntry();
        if (planetIDs.size() > 0) {
            int count;
            output = SheetUtils.prepForMetaData("PlanetaryColoniesMeta.csv", stream, false, null);
            for (Object next : metaIDs) {
                count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "PlanetaryColony");
                if (count <= 0) continue;
                output.println();
            }
            output.flush();
            stream.closeEntry();
            metaIDs = PlanetaryColoniesSheetWriter.dumpPlanetaryPins(acct, stream, planetIDs, at);
            if (metaIDs.size() > 0) {
                output = SheetUtils.prepForMetaData("PlanetaryPinsMeta.csv", stream, false, null);
                for (Object next : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "PlanetaryPin");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
            if ((metaIDs = PlanetaryColoniesSheetWriter.dumpPlanetaryLinks(acct, stream, planetIDs, at)).size() > 0) {
                output = SheetUtils.prepForMetaData("PlanetaryLinksMeta.csv", stream, false, null);
                for (Object next : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "PlanetaryLink");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
            if ((metaIDs = PlanetaryColoniesSheetWriter.dumpPlanetaryRoutes(acct, stream, planetIDs, at)).size() > 0) {
                output = SheetUtils.prepForMetaData("PlanetaryRoutesMeta.csv", stream, false, null);
                for (Object next : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "PlanetaryRoute");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
        }
    }
}

