/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.character.CharacterNotification;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class NotificationSheetWriter {
    private NotificationSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Notifications.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Notification ID", "Type", "Sender ID", "Sender Type", "Sent Date (Raw)", "Sent Date", "Msg Read", "Text"});
        ArrayList metaIDs = new ArrayList();
        CachedData.SimpleStreamExceptionHandler capture = new CachedData.SimpleStreamExceptionHandler();
        CachedData.stream((long)at, (contid, ats) -> CharacterNotification.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()), (boolean)true, (CachedData.StreamExceptionHandler)capture).forEach(nextNote -> {
            try {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(nextNote.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextNote.getNotificationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(nextNote.getType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextNote.getSenderID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(nextNote.getSenderType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextNote.getSentDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(nextNote.getSentDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(nextNote.isMsgRead(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextNote.getText(), SheetUtils.CellFormat.NO_STYLE));
            }
            catch (IOException e) {
                capture.handle(e);
            }
            metaIDs.add(nextNote.getCid());
        });
        output.flush();
        stream.closeEntry();
        CSVPrinter metaOutput = SheetUtils.prepForMetaData("NotificationsMeta.csv", stream, false, null);
        for (Long next : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, metaOutput, next, "CharacterNotification");
            if (count <= 0) continue;
            metaOutput.println();
        }
        metaOutput.flush();
        stream.closeEntry();
    }
}

