/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.character.CharacterMedal;
import enterprises.orbital.evekit.model.character.CharacterMedalGraphic;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MedalSheetWriter {
    private MedalSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Medals.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Medal ID", "Title", "Description", "Corporation ID", "Issued (Raw)", "Issued", "Issuer ID", "Reason", "Status"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List medals = CachedData.retrieveAll((long)at, (contid, at1) -> CharacterMedal.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        for (CharacterMedal characterMedal : medals) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(characterMedal.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterMedal.getMedalID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(characterMedal.getTitle(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterMedal.getDescription(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterMedal.getCorporationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(characterMedal.getIssued(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(characterMedal.getIssued()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(characterMedal.getIssuerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(characterMedal.getReason(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(characterMedal.getStatus(), SheetUtils.CellFormat.NO_STYLE));
            metaIDs.add(characterMedal.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MedalsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "CharacterMedal");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
        stream.putNextEntry(new ZipEntry("MedalGraphics.csv"));
        output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Medal ID", "Issued (Raw)", "Issued", "Part", "Layer", "Graphic", "Color"});
        metaIDs.clear();
        List medalGraphics = CachedData.retrieveAll((long)at, (contid, at1) -> CharacterMedalGraphic.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        for (CharacterMedalGraphic next : medalGraphics) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getMedalID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getIssued(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getIssued()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getPart(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLayer(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getGraphic(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getColor(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            metaIDs.add(next.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MedalGraphicsMeta.csv", stream, false, null);
        for (Long next : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, next, "CharacterMedalGraphic");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

