/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.character.CharacterMailMessage;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MailMessageSheetWriter {
    private MailMessageSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MailMessages.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Message ID", "Sender ID", "Sent Date (Raw)", "Sent Date", "Title", "Msg Read", "Labels", "Recipients", "Body"});
        ArrayList metaIDs = new ArrayList();
        CachedData.SimpleStreamExceptionHandler capture = new CachedData.SimpleStreamExceptionHandler();
        CachedData.stream((long)at, (contid, ats) -> CharacterMailMessage.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)ats, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()), (boolean)true, (CachedData.StreamExceptionHandler)capture).forEach(nextMsg -> {
            try {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(nextMsg.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextMsg.getMessageID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(nextMsg.getSenderID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(nextMsg.getSentDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(nextMsg.getSentDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(nextMsg.getTitle(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextMsg.isMsgRead(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(Arrays.toString((Object[])nextMsg.getLabels().toArray(new Integer[nextMsg.getLabels().size()])), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(Arrays.toString(nextMsg.getRecipients().stream().map(x -> "[" + x.getRecipientType() + ", " + x.getRecipientID() + "]").toArray(String[]::new)), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(nextMsg.getBody(), SheetUtils.CellFormat.NO_STYLE));
            }
            catch (IOException e) {
                capture.handle(e);
            }
            metaIDs.add(nextMsg.getCid());
        });
        output.flush();
        stream.closeEntry();
        CSVPrinter metaOutput = SheetUtils.prepForMetaData("MailMessagesMeta.csv", stream, false, null);
        for (Long next : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, metaOutput, next, "CharacterMailMessage");
            if (count <= 0) continue;
            metaOutput.println();
        }
        metaOutput.flush();
        stream.closeEntry();
    }
}

