/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.character.MailLabel;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MailLabelSheetWriter {
    private MailLabelSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("MailLabels.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Label ID", "Unread Count", "Name", "Color"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List lists = CachedData.retrieveAll((long)at, (contid, at1) -> MailLabel.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        for (MailLabel mailLabel : lists) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(mailLabel.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(mailLabel.getLabelID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(mailLabel.getUnreadCount(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(mailLabel.getName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(mailLabel.getColor(), SheetUtils.CellFormat.NO_STYLE));
            metaIDs.add(mailLabel.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("MailLabelsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "MailLabel");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

