/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.CharacterShip;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CharacterShipSheetWriter {
    private CharacterShipSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("CharacterShip.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Ship Type ID", "Ship Item ID", "Ship Name"});
        CharacterShip csheet = CharacterShip.get((SynchronizedEveAccount)acct, (long)at);
        if (csheet != null) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(csheet.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getShipTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getShipItemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getShipName(), SheetUtils.CellFormat.NO_STYLE));
            output.flush();
            stream.closeEntry();
            output = SheetUtils.prepForMetaData("CharacterShipMeta.csv", stream, false, null);
            SheetUtils.dumpNextMetaData(acct, output, csheet.getCid(), "CharacterShip");
        }
        output.flush();
        stream.closeEntry();
    }
}

