/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.CharacterSheet;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CharacterSheetSheetWriter {
    private CharacterSheetSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("CharacterSheet.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Character ID", "Character Name", "Corporation ID", "RaceID", "DoB (Raw)", "DoB", "BloodlineID", "AncestryID", "Gender", "Alliance ID", "Faction ID", "Description", "Security Status"});
        CharacterSheet csheet = CharacterSheet.get((SynchronizedEveAccount)acct, (long)at);
        if (csheet != null) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(csheet.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getCorporationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getRaceID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getDoB(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getDoB()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(csheet.getBloodlineID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getAncestryID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getGender(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getAllianceID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getFactionID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getDescription(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(Float.valueOf(csheet.getSecurityStatus()), SheetUtils.CellFormat.DOUBLE_STYLE));
            output.flush();
            stream.closeEntry();
            output = SheetUtils.prepForMetaData("CharacterSheetMeta.csv", stream, false, null);
            SheetUtils.dumpNextMetaData(acct, output, csheet.getCid(), "CharacterSheet");
        }
        output.flush();
        stream.closeEntry();
    }
}

