/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.CharacterSheetJump;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CharacterSheetJumpSheetWriter {
    private CharacterSheetJumpSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("CharacterSheetJump.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Jump Activation (Raw)", "Jump Activation", "Jump Fatigue (Raw)", "Jump Fatigue", "Jump Last Update (Raw)", "Jump Last Update"});
        CharacterSheetJump csheet = CharacterSheetJump.get((SynchronizedEveAccount)acct, (long)at);
        if (csheet != null) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(csheet.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getJumpActivation(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getJumpActivation()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(csheet.getJumpFatigue(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getJumpFatigue()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(csheet.getJumpLastUpdate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getJumpLastUpdate()), SheetUtils.CellFormat.DATE_STYLE));
            output.flush();
            stream.closeEntry();
            output = SheetUtils.prepForMetaData("CharacterSheetJumpMeta.csv", stream, false, null);
            SheetUtils.dumpNextMetaData(acct, output, csheet.getCid(), "CharacterSheetJump");
        }
        output.flush();
        stream.closeEntry();
    }
}

