/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.character.CharacterSheetClone;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CharacterSheetCloneSheetWriter {
    private CharacterSheetCloneSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("CharacterSheetClone.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Clone Jump Date (Raw)", "Clone Jump Date", "Home Station ID", "Home Station Type", "Last Station Change Date (Raw)", "Last Station Change Date"});
        CharacterSheetClone csheet = CharacterSheetClone.get((SynchronizedEveAccount)acct, (long)at);
        if (csheet != null) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(csheet.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getCloneJumpDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getCloneJumpDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(csheet.getHomeStationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getHomeStationType(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getLastStationChangeDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(csheet.getLastStationChangeDate()), SheetUtils.CellFormat.DATE_STYLE));
            output.flush();
            stream.closeEntry();
            output = SheetUtils.prepForMetaData("CharacterSheetCloneMeta.csv", stream, false, null);
            SheetUtils.dumpNextMetaData(acct, output, csheet.getCid(), "CharacterSheetClone");
        }
        output.flush();
        stream.closeEntry();
    }
}

