/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.capsuleer;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.AttributeSelector;
import enterprises.orbital.evekit.model.CachedData;
import enterprises.orbital.evekit.model.character.CalendarEventAttendee;
import enterprises.orbital.evekit.model.character.UpcomingCalendarEvent;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CalendarSheetWriter {
    private CalendarSheetWriter() {
    }

    private static List<Long> dumpCalendarEventAttendees(SynchronizedEveAccount acct, ZipOutputStream stream, List<UpcomingCalendarEvent> events, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("CalendarEventAttendees.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Event ID", "Character ID", "Response"});
        for (UpcomingCalendarEvent event : events) {
            int eventID = event.getEventID();
            List allAttendees = CachedData.retrieveAll((long)at, (contid, at1) -> CalendarEventAttendee.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.values((Object[])new Object[]{eventID}), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
            if (allAttendees.size() <= 0) continue;
            for (CalendarEventAttendee next : allAttendees) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getEventID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getCharacterID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getResponse(), SheetUtils.CellFormat.NO_STYLE));
                itemIDs.add(next.getCid());
            }
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("UpcomingCalendarEvents.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Event ID", "Event Title", "Event Text", "Event Date (Raw)", "Event Date", "Duration", "Owner ID", "Owner Name", "Response", "Importance", "Owner Type"});
        List events = CachedData.retrieveAll((long)at, (contid, at1) -> UpcomingCalendarEvent.accessQuery((SynchronizedEveAccount)acct, (long)contid, (int)1000, (boolean)false, (AttributeSelector)at1, (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any(), (AttributeSelector)AttributeSelector.any()));
        List<Object> metaIDs = new ArrayList();
        for (Object next : events) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getEventID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getEventTitle(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getEventText(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getEventDate(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getEventDate()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getDuration(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getOwnerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getOwnerName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getResponse(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getImportance(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getOwnerType(), SheetUtils.CellFormat.NO_STYLE));
            metaIDs.add(next.getCid());
        }
        output.flush();
        stream.closeEntry();
        if (events.size() > 0) {
            int count;
            output = SheetUtils.prepForMetaData("UpcomingCalendarEventsMeta.csv", stream, false, null);
            for (Object next : metaIDs) {
                count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "UpcomingCalendarEvent");
                if (count <= 0) continue;
                output.println();
            }
            output.flush();
            stream.closeEntry();
            metaIDs = CalendarSheetWriter.dumpCalendarEventAttendees(acct, stream, events, at);
            if (metaIDs.size() > 0) {
                output = SheetUtils.prepForMetaData("CalendarEventAttendeesMeta.csv", stream, false, null);
                for (Object next : metaIDs) {
                    count = SheetUtils.dumpNextMetaData(acct, output, (Long)next, "CalendarEventAttendee");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
        }
    }
}

