/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.Fuel;
import enterprises.orbital.evekit.model.corporation.Starbase;
import enterprises.orbital.evekit.model.corporation.StarbaseDetail;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class StarbaseSheetWriter {
    private StarbaseSheetWriter() {
    }

    public static List<Long> dumpStarbaseDetails(SynchronizedEveAccount acct, ZipOutputStream stream, List<Long> starbaseIDs, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("StarbaseDetails.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Item ID", "State", "State Timestamp (Raw)", "State Timestamp", "Online Timestamp (Raw)", "Online Timestamp", "Usage Flags", "Deploy Flags", "Allow Alliance Members", "Allow Corporation Members", "Use Standings From", "On Aggression Enabled", "On Aggression Standing", "On Corporation War Enabled", "On Corporation War Standing", "On Standing Drop Enabled", "On Standing Drop Standing", "On Status Drop Enabled", "On Status Drop Standing"});
        for (long starbaseID : starbaseIDs) {
            StarbaseDetail next = StarbaseDetail.get((SynchronizedEveAccount)acct, (long)at, (long)starbaseID);
            if (next == null) continue;
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getItemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getState(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getStateTimestamp(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getStateTimestamp()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getOnlineTimestamp(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getOnlineTimestamp()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getUsageFlags(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getDeployFlags(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.isAllowAllianceMembers(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.isAllowCorporationMembers(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.isOnAggressionEnabled(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getOnAggressionStanding(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.isOnCorporationWarEnabled(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getOnCorporationWarStanding(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.isOnStandingDropEnabled(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getOnStandingDropStanding(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.isOnStatusDropEnabled(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getOnStandingDropStanding(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            itemIDs.add(next.getCid());
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static List<Long> dumpFuel(SynchronizedEveAccount acct, ZipOutputStream stream, List<Long> stationIDs, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("StarbaseFuel.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Item ID", "Type ID", "Quantity"});
        for (long stationID : stationIDs) {
            List batch = Fuel.getAllByItemID((SynchronizedEveAccount)acct, (long)at, (long)stationID);
            if (batch.size() <= 0) continue;
            for (Fuel next : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getItemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getQuantity(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
                itemIDs.add(next.getCid());
            }
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Starbases.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Item ID", "Location ID", "Moon ID", "Online Timestamp (Raw)", "Online Timestamp", "State", "State Timestamp (Raw)", "State Timestamp", "Type ID", "Standing Owner ID"});
        List batch = Starbase.getAll((SynchronizedEveAccount)acct, (long)at);
        ArrayList<Long> starbaseIDs = new ArrayList<Long>();
        for (Starbase next : batch) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getItemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getLocationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getMoonID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getOnlineTimestamp(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getOnlineTimestamp()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getState(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getStateTimestamp(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(new Date(next.getStateTimestamp()), SheetUtils.CellFormat.DATE_STYLE), new SheetUtils.DumpCell(next.getTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getStandingOwnerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            starbaseIDs.add(next.getItemID());
        }
        output.flush();
        stream.closeEntry();
        if (batch.size() > 0) {
            int count;
            output = SheetUtils.prepForMetaData("StarbasesMeta.csv", stream, false, null);
            for (Starbase next : batch) {
                int count2 = SheetUtils.dumpNextMetaData(acct, output, next.getCid(), "Starbase");
                if (count2 <= 0) continue;
                output.println();
            }
            output.flush();
            stream.closeEntry();
            List<Long> writes = StarbaseSheetWriter.dumpStarbaseDetails(acct, stream, starbaseIDs, at);
            if (writes.size() > 0) {
                output = SheetUtils.prepForMetaData("StarbaseDetailsMeta.csv", stream, false, null);
                for (Long next : writes) {
                    count = SheetUtils.dumpNextMetaData(acct, output, next, "StarbaseDetail");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
            if ((writes = StarbaseSheetWriter.dumpFuel(acct, stream, starbaseIDs, at)).size() > 0) {
                output = SheetUtils.prepForMetaData("FuelMeta.csv", stream, false, null);
                for (Long next : writes) {
                    count = SheetUtils.dumpNextMetaData(acct, output, next, "Fuel");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
        }
    }
}

