/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.SecurityTitle;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class SecurityTitleSheetWriter {
    private SecurityTitleSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("SecurityTitles.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Title ID", "Title Name"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List titles = SecurityTitle.getAll((SynchronizedEveAccount)acct, (long)at);
        for (SecurityTitle securityTitle : titles) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(securityTitle.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(securityTitle.getTitleID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(securityTitle.getTitleName(), SheetUtils.CellFormat.NO_STYLE));
            metaIDs.add(securityTitle.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("SecurityTitlesMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "SecurityTitle");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

