/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.Outpost;
import enterprises.orbital.evekit.model.corporation.OutpostServiceDetail;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class OutpostSheetWriter {
    private OutpostSheetWriter() {
    }

    public static List<Long> dumpOutpostServiceDetail(SynchronizedEveAccount acct, ZipOutputStream stream, List<Long> stations, long at) throws IOException {
        ArrayList<Long> itemIDs = new ArrayList<Long>();
        stream.putNextEntry(new ZipEntry("OutpostServices.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Station ID", "Service Name", "Owner ID", "Min Standing", "Surcharge Per Bad Standing", "Discount Per Good Standing"});
        for (long stationID : stations) {
            List batch = OutpostServiceDetail.getAllByStationID((SynchronizedEveAccount)acct, (long)at, (long)stationID);
            if (batch.size() <= 0) continue;
            for (OutpostServiceDetail next : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getStationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getServiceName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getOwnerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getMinStanding(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getSurchargePerBadStanding(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(next.getDiscountPerGoodStanding(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE));
                itemIDs.add(next.getCid());
            }
            output.println();
        }
        output.flush();
        stream.closeEntry();
        return itemIDs;
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Outposts.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Station ID", "Owner ID", "Station Name", "Solar System ID", "Docking Cost Per Ship Volume", "Office Rental Cost", "Station Type ID", "Reprocessing Efficiency", "Reprocessing Station Take", "Standing Owner ID", "X", "Y", "Z"});
        List batch = Outpost.getAll((SynchronizedEveAccount)acct, (long)at);
        ArrayList<Long> stationIDs = new ArrayList<Long>();
        for (Outpost next : batch) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(next.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getStationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getOwnerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getStationName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(next.getSolarSystemID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getDockingCostPerShipVolume(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(next.getOfficeRentalCost(), SheetUtils.CellFormat.BIG_DECIMAL_STYLE), new SheetUtils.DumpCell(next.getStationTypeID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getReprocessingEfficiency(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getReprocessingStationTake(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(next.getStandingOwnerID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getX(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getY(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(next.getZ(), SheetUtils.CellFormat.LONG_NUMBER_STYLE));
            stationIDs.add(next.getStationID());
        }
        output.flush();
        stream.closeEntry();
        if (batch.size() > 0) {
            output = SheetUtils.prepForMetaData("OutpostsMeta.csv", stream, false, null);
            for (Outpost next : batch) {
                int count = SheetUtils.dumpNextMetaData(acct, output, next.getCid(), "Outpost");
                if (count <= 0) continue;
                output.println();
            }
            output.flush();
            stream.closeEntry();
            List<Long> writes = OutpostSheetWriter.dumpOutpostServiceDetail(acct, stream, stationIDs, at);
            if (writes.size() > 0) {
                output = SheetUtils.prepForMetaData("OutpostServicesMeta.csv", stream, false, null);
                for (Long next : writes) {
                    int count = SheetUtils.dumpNextMetaData(acct, output, next, "OutpostServiceDetail");
                    if (count <= 0) continue;
                    output.println();
                }
                output.flush();
                stream.closeEntry();
            }
        }
    }
}

