/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.CorporationTitle;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CorporationTitleSheetWriter {
    private CorporationTitleSheetWriter() {
    }

    public static String setToString(Set<Long> convert) {
        return Arrays.toString((Object[])convert.toArray(new Long[convert.size()]));
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Titles.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Title ID", "Title Name", "Grantable Roles", "Grantable Roles At Base", "Grantable Roles At HQ", "Grantable Roles At Other", "Roles", "Roles At Base", "Roles At HQ", "Roles At Other"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        List batch = CorporationTitle.getAll((SynchronizedEveAccount)acct, (long)at);
        for (CorporationTitle corporationTitle : batch) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(corporationTitle.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(corporationTitle.getTitleID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(corporationTitle.getTitleName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(CorporationTitleSheetWriter.setToString(corporationTitle.getGrantableRoles()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(CorporationTitleSheetWriter.setToString(corporationTitle.getGrantableRolesAtBase()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(CorporationTitleSheetWriter.setToString(corporationTitle.getGrantableRolesAtHQ()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(CorporationTitleSheetWriter.setToString(corporationTitle.getGrantableRolesAtOther()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(CorporationTitleSheetWriter.setToString(corporationTitle.getRoles()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(CorporationTitleSheetWriter.setToString(corporationTitle.getRolesAtBase()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(CorporationTitleSheetWriter.setToString(corporationTitle.getRolesAtHQ()), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(CorporationTitleSheetWriter.setToString(corporationTitle.getRolesAtOther()), SheetUtils.CellFormat.NO_STYLE));
            metaIDs.add(corporationTitle.getCid());
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("TitlesMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "CorporationTitle");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

