/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.corporation;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.corporation.CorporationSheet;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CorporationSheetSheetWriter {
    private CorporationSheetSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("CorporationSheet.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Alliance ID", "Alliance Name", "Ceo ID", "Ceo Name", "Corporation ID", "Corporation Name", "Description", "Logo Color 1", "Logo Color 2", "Logo Color 3", "Logo Graphic ID", "Logo Shape 1", "Logo Shape 2", "Logo Shape 3", "Member Count", "Member Limit", "Shares", "Station ID", "Station Name", "Tax Rate", "Ticker", "Url"});
        CorporationSheet csheet = CorporationSheet.get((SynchronizedEveAccount)acct, (long)at);
        if (csheet != null) {
            SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(csheet.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getAllianceID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getAllianceName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getCeoID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getCeoName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getCorporationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getCorporationName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getDescription(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getLogoColor1(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getLogoColor2(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getLogoColor3(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getLogoGraphicID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getLogoShape1(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getLogoShape2(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getLogoShape3(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getMemberCount(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getMemberLimit(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getShares(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getStationID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(csheet.getStationName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getTaxRate(), SheetUtils.CellFormat.DOUBLE_STYLE), new SheetUtils.DumpCell(csheet.getTicker(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(csheet.getUrl(), SheetUtils.CellFormat.NO_STYLE));
            output.flush();
            stream.closeEntry();
            output = SheetUtils.prepForMetaData("CorporationSheetMeta.csv", stream, false, null);
            SheetUtils.dumpNextMetaData(acct, output, csheet.getCid(), "CorporationSheet");
        }
        output.flush();
        stream.closeEntry();
    }
}

