/*
 * Decompiled with CFR 0.152.
 */
package enterprises.orbital.evekit.snapshot.common;

import enterprises.orbital.evekit.account.SynchronizedEveAccount;
import enterprises.orbital.evekit.model.common.Standing;
import enterprises.orbital.evekit.snapshot.SheetUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class StandingSheetWriter {
    private StandingSheetWriter() {
    }

    public static void dumpToSheet(SynchronizedEveAccount acct, ZipOutputStream stream, long at) throws IOException {
        stream.putNextEntry(new ZipEntry("Standings.csv"));
        CSVPrinter output = CSVFormat.EXCEL.print((Appendable)new OutputStreamWriter(stream));
        output.printRecord(new Object[]{"ID", "Standing Entity", "From ID", "From Name", "Standing"});
        ArrayList<Long> metaIDs = new ArrayList<Long>();
        long contid = -1L;
        List batch = Standing.getAllStandings((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        while (batch.size() > 0) {
            for (Standing standing : batch) {
                SheetUtils.populateNextRow(output, new SheetUtils.DumpCell(standing.getCid(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(standing.getStandingEntity(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(standing.getFromID(), SheetUtils.CellFormat.LONG_NUMBER_STYLE), new SheetUtils.DumpCell(standing.getFromName(), SheetUtils.CellFormat.NO_STYLE), new SheetUtils.DumpCell(standing.getStanding(), SheetUtils.CellFormat.DOUBLE_STYLE));
                metaIDs.add(standing.getCid());
            }
            contid = ((Standing)batch.get(batch.size() - 1)).getCid();
            batch = Standing.getAllStandings((SynchronizedEveAccount)acct, (long)at, (int)1000, (long)contid);
        }
        output.flush();
        stream.closeEntry();
        output = SheetUtils.prepForMetaData("StandingsMeta.csv", stream, false, null);
        for (Long l : metaIDs) {
            int count = SheetUtils.dumpNextMetaData(acct, output, l, "Standing");
            if (count <= 0) continue;
            output.println();
        }
        output.flush();
        stream.closeEntry();
    }
}

